/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.ThreeByteInteger;
import com.ibm.hwmca.fw.util.Trace;
import java.math.BigInteger;

public class BinaryNumber {
    private static final String TRACE_MASKT = "XFRMBNMT";
    private static final String TRACE_MASKF = "XFRMBNMF";
    private static final String TRACE_MASKD = "XFRMBNMD";
    private static final BigInteger ULONG_ZERO = new BigInteger("0");
    private static final byte[] ULONG_MASK = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1};

    public static byte toByte(byte[] number) {
        byte result = 0;
        if (number != null) {
            int size = number.length;
            if (size != 1) {
                Trace.trace(TRACE_MASKF, "BinaryNumber.toByte(0x" + HexString.toHex(number) + ": inconsistent length");
            }
            if (size != 0) {
                result = number[size - 1];
            }
        }
        return result;
    }

    public static short toShort(byte[] number) {
        short result = 0;
        if (number != null) {
            int start;
            int size = number.length;
            if (size <= 0 || size > 2) {
                Trace.trace(TRACE_MASKF, "BinaryNumber.toShort(0x" + HexString.toHex(number) + ": inconsistent length");
            }
            if ((start = size - 2) < 0) {
                start = 0;
            }
            for (int ix = start; ix < size; ++ix) {
                result = (short)(result << 8 | 0xFF & number[ix]);
            }
        }
        return result;
    }

    public static int toInt(byte[] number) {
        int result = 0;
        if (number != null) {
            int start;
            int size = number.length;
            if (size <= 0 || size > 4) {
                Trace.trace(TRACE_MASKF, "BinaryNumber.toInt(0x" + HexString.toHex(number) + "): inconsistent length");
            }
            if ((start = size - 4) < 0) {
                start = 0;
            }
            for (int ix = start; ix < size; ++ix) {
                result = result << 8 | 0xFF & number[ix];
            }
        }
        return result;
    }

    public static long toLong(byte[] number) {
        long result = 0L;
        if (number != null) {
            int start;
            int size = number.length;
            if (size <= 0 || size > 8) {
                Trace.trace(TRACE_MASKF, "BinaryNumber.toLong(0x" + HexString.toHex(number) + "): inconsistent length");
            }
            if ((start = size - 8) < 0) {
                start = 0;
            }
            for (int ix = start; ix < size; ++ix) {
                result = result << 8 | (long)(0xFF & number[ix]);
            }
        }
        return result;
    }

    public static short toUnsignedByte(byte[] number) {
        int result = 0;
        if (number != null) {
            int size = number.length;
            if (size != 1) {
                Trace.trace(TRACE_MASKF, "BinaryNumber.toUnsignedByte(0x" + HexString.toHex(number) + "): inconsistent length");
            }
            if (size != 0) {
                result = number[size - 1];
            }
        }
        return (short)(0xFF & result);
    }

    public static int toUnsignedShort(byte[] number) {
        int result = 0;
        if (number != null) {
            int start;
            int size = number.length;
            if (size <= 0 || size > 2) {
                Trace.trace(TRACE_MASKF, "BinaryNumber.toUnsignedShort(0x" + HexString.toHex(number) + "): inconsistent length");
            }
            if ((start = size - 2) < 0) {
                start = 0;
            }
            for (int ix = start; ix < size; ++ix) {
                result = result << 8 | 0xFF & number[ix];
            }
        }
        return result;
    }

    public static long toUnsignedInt(byte[] number) {
        long result = 0L;
        if (number != null) {
            int start;
            int size = number.length;
            if (size <= 0 || size > 4) {
                Trace.trace(TRACE_MASKF, "BinaryNumber.toUnsignedInt(0x" + HexString.toHex(number) + "): inconsistent length");
            }
            if ((start = size - 4) < 0) {
                start = 0;
            }
            for (int ix = start; ix < size; ++ix) {
                result = result << 8 | (long)(0xFF & number[ix]);
            }
        }
        return result;
    }

    public static BigInteger toUnsignedLong(byte[] number) {
        BigInteger result = ULONG_ZERO;
        if (number != null) {
            int size = number.length;
            if (size <= 0 || size > 8) {
                Trace.trace(TRACE_MASKF, "BinaryNumber.toUnsignedLong(0x" + HexString.toHex(number) + "): inconsistent length");
            }
            byte[] value = number;
            if (size > 8) {
                value = new byte[8];
                System.arraycopy(number, size - 8, value, 0, 8);
            }
            result = new BigInteger(1, value).and(new BigInteger(ULONG_MASK));
        }
        return result;
    }

    public static Number toNumber(byte[] number, int length) {
        Number result = null;
        if (number != null) {
            result = length == 1 || length == 0 && number.length == 1 ? (Number)new Byte(BinaryNumber.toByte(number)) : (Number)(length == 2 || length == 0 && number.length == 2 ? (Number)new Short(BinaryNumber.toShort(number)) : (Number)(length == 3 || length == 4 || length == 0 && number.length <= 4 ? (Number)new Integer(BinaryNumber.toInt(number)) : (Number)new Long(BinaryNumber.toLong(number))));
        }
        return result;
    }

    public static Number toNumber(byte[] number) {
        return BinaryNumber.toNumber(number, 0);
    }

    public static byte[] fromByte(byte number, int size) {
        return BinaryNumber.fromNumber(new Byte(number), size);
    }

    public static byte[] fromByte(byte number) {
        return BinaryNumber.fromNumber(new Byte(number), 0);
    }

    public static byte[] fromShort(short number, int size) {
        return BinaryNumber.fromNumber(new Short(number), size);
    }

    public static byte[] fromShort(short number) {
        return BinaryNumber.fromNumber(new Short(number), 0);
    }

    public static byte[] fromInt(int number, int size) {
        return BinaryNumber.fromNumber(new Integer(number), size);
    }

    public static byte[] fromInt(int number) {
        return BinaryNumber.fromNumber(new Integer(number), 0);
    }

    public static byte[] fromLong(long number, int size) {
        return BinaryNumber.fromNumber(new Long(number), size);
    }

    public static byte[] fromLong(long number) {
        return BinaryNumber.fromNumber(new Long(number), 0);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] fromNumber(Number number, int size) {
        byte[] result;
        block20: {
            result = null;
            if (number == null) break block20;
            if (size < 0) {
                throw new IllegalArgumentException("Size must be nonnegative");
            }
            if (number instanceof BigInteger) {
                int ix;
                byte[] byteValue = ((BigInteger)number).toByteArray();
                if (size == 0) {
                    size = byteValue.length;
                    if (byteValue[0] == 0) {
                        --size;
                    }
                }
                result = new byte[size];
                for (ix = 0; ix < size; ++ix) {
                    result[ix] = 0;
                }
                for (ix = 0; ix < size && ix < byteValue.length; ++ix) {
                    result[size - ix - 1] = byteValue[byteValue.length - ix - 1];
                }
            } else {
                void var3_4;
                int numberSize;
                if (number instanceof Byte) {
                    numberSize = 1;
                } else if (number instanceof Short) {
                    numberSize = 2;
                } else if (number instanceof ThreeByteInteger) {
                    numberSize = 3;
                } else if (number instanceof Integer) {
                    numberSize = 4;
                } else if (number instanceof Long) {
                    numberSize = 8;
                } else {
                    throw new NumberFormatException("Number argument must be integral");
                }
                if (size == 0) {
                    size = var3_4;
                }
                result = new byte[size];
                for (int ix = 0; ix < size; ++ix) {
                    result[ix] = 0;
                }
                long value = number.longValue();
                for (int ix = 0; ix < size && ix < var3_4; ++ix) {
                    result[size - ix - 1] = (byte)(value & 0xFFL);
                    value >>= 8;
                }
            }
        }
        return result;
    }

    public static byte[] fromNumber(Number number) {
        return BinaryNumber.fromNumber(number, 0);
    }

    public static byte[] swapByteOrder(byte[] number) {
        byte[] result = null;
        if (number != null) {
            int size = number.length;
            result = new byte[size];
            for (int ix = 0; ix < size; ++ix) {
                result[ix] = number[size - ix - 1];
            }
        }
        return result;
    }
}

